# -*- coding: utf-8 -*-
"""r11.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/14KLHm9oat-EFUsj1k8lKX0TJFUHyycm7
"""

import numpy as np
import matplotlib.pyplot as plt

from scipy.linalg import null_space

import sympy as sym

# UWAGA: poniżej zdefiniowano globalne ustawienia związane z wyglądem rysunków,
# które wykorzystano do wygenerowania rysunków pokazanych w książce

from IPython import display
display.set_matplotlib_formats('svg') # Rysunki w formacie wektorowym
plt.rcParams.update({'font.size':14}) # Rozmiar czcionki



"""# Kod tworzący rysunek 11.2

"""

x = [ 1,2,3,4,5 ]
y = [ 0,3,2,5,5 ]

X = np.hstack((np.ones((5,1)),np.array(x,ndmin=2).T))
yHat = X @ np.linalg.inv(X.T@X) @ X.T @ y

plt.figure(figsize=(6,6))
plt.plot(x,y,'ks',markersize=15,label='Obserwacje')
plt.plot(x,yHat,'o-',color=[.6,.6,.6],linewidth=3,markersize=8,label='Przewidywania')

for n,y,yHat in zip(x,y,yHat):
  plt.plot([n,n],[y,yHat],'--',color=[.8,.8,.8],zorder=-10)

plt.legend()
plt.savefig('rys11.2.png',dpi=300)
plt.show()



"""# Przykład z wymyślonymi danymi"""

numcourses = [13,4,12,3,14,13,12,9,11,7,13,11,9,2,5,7,10,0,9,7]
happiness  = [70,25,54,21,80,68,84,62,57,40,60,64,45,38,51,52,58,21,75,70]

plt.figure(figsize=(6,6))

plt.plot(numcourses,happiness,'ks',markersize=15)
plt.xlabel('Liczba kursów, w których udział wzięła dana osoba')
plt.ylabel('Ogólne zadowolenie z życia')
plt.xlim([-1,15])
plt.ylim([0,100])
plt.grid()
plt.xticks(range(0,15,2))
plt.savefig('rys11.3.png',dpi=300)
plt.show()

X = np.array(numcourses,ndmin=2).T
print(X.shape)

# dopasowanie modelu przy użyciu odwrotności lewostronnej
X_leftinv = np.linalg.inv(X.T@X) @ X.T

# wyznaczam współczynniki
beta = X_leftinv @ happiness
beta

pred_happiness = X@beta


plt.figure(figsize=(6,6))

plt.plot(numcourses,happiness,'ks',markersize=15)
plt.plot(numcourses,pred_happiness,'o-',color=[.6,.6,.6],linewidth=3,markersize=8)

for n,y,yHat in zip(numcourses,happiness,pred_happiness):
  plt.plot([n,n],[y,yHat],'--',color=[.8,.8,.8],zorder=-10)

plt.xlabel('Liczba kursów, w których udział wzięła dana osoba')
plt.ylabel('Ogólne zadowolenie z życia')
plt.xlim([-1,15])
plt.ylim([0,100])
plt.xticks(range(0,15,2))
plt.legend(['Rzeczywiste dane','Przewidywania','Reszty'])
plt.title(f'SSE = {np.sum((pred_happiness-happiness)**2):.2f}')
plt.savefig('rys11.4.png',dpi=300)
plt.show()

X = np.hstack((np.ones((20,1)),np.array(numcourses,ndmin=2).T))
print(X.shape)

X_leftinv = np.linalg.inv(X.T@X) @ X.T

beta = X_leftinv @ happiness
beta

pred_happiness = X@beta


plt.figure(figsize=(6,6))

plt.plot(numcourses,happiness,'ks',markersize=15)
plt.plot(numcourses,pred_happiness,'o-',color=[.6,.6,.6],linewidth=3,markersize=8)

for n,y,yHat in zip(numcourses,happiness,pred_happiness):
  plt.plot([n,n],[y,yHat],'--',color=[.8,.8,.8],zorder=-10)

plt.xlabel('Liczba kursów, w których udział wzięła dana osoba')
plt.ylabel('Ogólne zadowolenie z życia')
plt.xlim([-1,15])
plt.ylim([0,100])
plt.xticks(range(0,15,2))
plt.legend(['Rzeczywiste dane','Przewidywania','Reszty'])
plt.title(f'SSE = {np.sum((pred_happiness-happiness)**2):.2f}')
plt.savefig('rys11.5.png',dpi=300)
plt.show()



"""# Ćwiczenie 1."""

# obliczam reszty
res = happiness-pred_happiness


# powinienem otrzymać + jakiś błąd
('Iloczyn skalarny: ' + str(np.dot(pred_happiness,res)) )
print('Korelacja: ' + str(np.corrcoef(pred_happiness,res)[0,1]))
print(' ')


# wykres
plt.figure(figsize=(6,6))
plt.plot(res,pred_happiness,'ko',markersize=12)
plt.xlabel('Reszty')
plt.ylabel('Wartości przewidywane przez model')
plt.title(f'r = {np.corrcoef(pred_happiness,res)[0,1]:.20f}')
plt.savefig('rys11.6.png',dpi=300)
plt.show()

# mniejsza jest korelacja, np. dlatego, że podczas jej wyznaczania dzielimy przez normy wektorów
np.linalg.norm(res)



"""# Ćwiczenie 2."""

# Wektor reszt jest ortogonalny do całej podprzestrzeni rozpinanej przez macierz zależności.

# Zademonstruję to pokazując, że wektor reszt należy do lewostronnego jądra macierzy zależności, które znajdę
# za pomocą funkcji scipy.linalg.null_space. Następnie rozszerzę macierz będącą bazą jądra o wektor reszt i pokażę,
# że macierz ta ma taki sam rząd jak macierz bazowa.

nullspace = null_space(X.T)


# rozszerzam  macierz
nullspaceAugment = np.hstack( (nullspace,res.reshape(-1,1)) )


# wyświetlam rzędy
print(f'dim(  N(X)    ) = {np.linalg.matrix_rank(nullspace)}')
print(f'dim( [N(X)|r] ) = {np.linalg.matrix_rank(nullspaceAugment)}')



"""# Ćwiczenie 3."""

### odkomentuj te linie, aby użyć losowych macierzy i wektorów.
# M,N = 20,3
# X = np.random.randn(M,N)
# happiness = np.random.randn(M,1)


# macierz zależności i rozwiązanie korzystające z odwrotności lewostronnej
X = np.hstack((np.ones((20,1)),np.array(numcourses,ndmin=2).T))
beta1 = np.linalg.inv(X.T@X) @ X.T @ happiness


# rozkład QR
Q,R = np.linalg.qr(X)

# wyznaczam współczynniki beta na podstawie przekształcenia matematycznego
beta2 = np.linalg.inv(R) @ (Q.T@happiness)

# oraz korzystając z podstawiania wstecznego
# muszą zamienić Q'y w wektor kolumnowy
tmp = (Q.T@happiness).reshape(-1,1)
Raug = np.hstack( (R,tmp) ) # macierz rozszerzona
Raug_r = sym.Matrix(Raug).rref()[0] # sprowadzenie do postaci schodkowej
beta3 = np.array(Raug_r[:,-1]) # konwersja z powrotem na wektor z NumPy


print('Współczynniki beta z metody korzystającej z odwrotności lewostronnej: ')
print(np.round(beta1,3)), print(' ')

print('Współczynniki beta z metody korzystającej z odwracania macierzy za pomocą rozkładu QR: ')
print(np.round(beta2,3)), print(' ')

print('Współczynniki beta z metody korzystającej z rozkładu QR i podstawiania wstecznego: ')
print(np.round(np.array(beta3.T).astype(float),3))

# wyświetlam macierze
print('Macierz R:')
print(np.round(R,3)) # macierz trójkątna górna (jak zapewne wiesz)

print(' ')
print("Macierz R|Q'y:")
print(np.round(Raug,3))

print(' ')
print("Zredukowana forma schodkowa macierzy (R|Q'y):")
print(np.round(np.array(Raug_r).astype(float),3)) # zamieniam na floaty



"""# Ćwiczenie 4."""

# ogólne zadowolenie z życia z wartościami odstającym (ups!)
happiness_oops1 = [170,25,54,21,80,68,84,62,57,40,60,64,45,38,51,52,58,21,75,70]
happiness_oops2 = [70,25,54,21,80,68,84,62,57,40,60,64,45,38,51,52,58,21,75,170]


# macierz zależności i jej lewostronna odwrotność (nie zmienia się wraz z danymi)
X = np.hstack((np.ones((20,1)),np.array(numcourses,ndmin=2).T))
X_leftinv = np.linalg.inv(X.T@X) @ X.T



_,axs = plt.subplots(1,3,figsize=(16,5))

for axi,y in zip(axs,[happiness,happiness_oops1,happiness_oops2]):

  # obliczam parametry najlepszego dopasowania
  beta = X_leftinv @ y

  # przewidywanie
  pred_happiness = X@beta


  # wykreślam dane i przewidywania
  axi.plot(numcourses,y,'ks',markersize=15)
  axi.plot(numcourses,pred_happiness,'o-',color=[.6,.6,.6],linewidth=3,markersize=8)

  # wykreślam reszty
  for n,y,yHat in zip(numcourses,y,pred_happiness):
    axi.plot([n,n],[y,yHat],'--',color=[.8,.8,.8],zorder=-10)

  # poprawiam wygląd wykresu
  axi.set(xlabel='Liczba kursów, w których udział wzięła dana osoba',ylabel='Ogólne zadowolenie z życia',
          xlim=[-1,15],ylim=[0,100],xticks=range(0,15,2))
  axi.legend(['Rzeczywiste dane','Przewidywania','Reszty'])
  axi.set_title(f'SSE = {np.sum((pred_happiness-y)**2):.2f}')



plt.tight_layout()
plt.savefig('rys11.7.png',dpi=300)
plt.show()



"""# Ćwiczenie 5."""

# rozmiar macierzy
n = 6

# losowa „macierz zależności”
X = np.random.randn(n,n)

# macierz wartości docelowych (macierz jednostkowa)
Y = np.eye(n)


# znajdowanie najlepszego dopasowania kolumna po kolumnie
Xinv1 = np.zeros_like(X)

for coli in range(n):
  Xinv1[:,coli] = np.linalg.inv(X.T@X) @ X.T @ Y[:,coli]



# to samo, ale bez użycia pętli
Xinv2 = np.linalg.inv(X.T@X) @ X.T @ Y


# obliczanie odwrotności za pomocą inv()
Xinv3 = np.linalg.inv(X)


# wizualizacja
_,axs = plt.subplots(1,3,figsize=(10,6))

axs[0].imshow( Xinv1@X ,cmap='gray')
axs[0].set_title('Metoda najmniejszych\nkwadratów:\nkolumna po kolumnie')

axs[1].imshow( Xinv2@X ,cmap='gray' )
axs[1].set_title('Metoda najmniejszych\nkwadratów:\ncała macierz naraz')

axs[2].imshow( Xinv3@X ,cmap='gray' )
axs[2].set_title('Funkcja inv()\n')


for a in axs: a.set(xticks=[],yticks=[])

plt.tight_layout()
plt.savefig('rys11.8.png',dpi=300)
plt.show()

# pokazanie, że wyniki są sobie równe
# zwróć uwagę na duże błędy numeryczne w porównaniu do inv() -- odwracanie za pomocą metody najmniejszych kwadratów
# korzystającej z odwrotności lewostronnej jest niestabilne numerycznie!



print(Xinv1-Xinv2)
print(' ')

print(Xinv1-Xinv3)
print(' ')

print(Xinv2-Xinv3)

